let x,y,size;
let xSpeed,ySpeed,xDir,yDir;
let shapey1;
let shapeArr = [];
let circ;



function setup() {

createCanvas(1000,700);

shapey1 = new MovingShape();
circ = new MovingCircle(width/2, height/2, 80);

x = width/2; 
y = height/2; 
size = 10;

xSpeed = random(0.3,5);
ySpeed = random(0.3,5);
xDir = 1;
yDir = 1;

for(let i = 0; i < 200; i++) {
  shapeArr.push(new MovingShape(random(0,width),random(0,height),random(1,40)));
}

  
}

function draw() {

noStroke(); 
rectMode(CORNER); 
fill( 255, 255, 255, 80); 
rect(0, 0, width, height); 

display();
move();

shapey1.move();
shapey1.display();

circ.move();
circ.display();

for(let i = 0; i < 200; i++) {
  shapeArr[i].move();
  shapeArr[i].display();
}
  
}

function move () {

x = x + (xSpeed * xDir); 
y = y + (ySpeed * yDir); 

if(x > (width-size) || x < size){
  xDir = xDir * -1; 
  
}

if(y > (height-size) || y < size){
  yDir = yDir * -1; 
}

}

function display () {

  stroke(10);
  rectMode(CENTER);
  fill(0);
  rect(x, y,size,size);
  
}

class MovingShape {
    
  constructor(startX, startY, startSize){
    this.x = startX;
    this.y = startY;
    this.size = startSize;
      this.xSpeed = random(0.3,5);
      this.ySpeed = random(0.3,5);
      this.xDir = 1;
      this.yDir = 1;
  }

  move() {
      
      this.x = this.x + (this.xSpeed * this.xDir);
      this.y = this.y + (this.ySpeed * this.yDir);

      if(this.x > (width-(this.size/2)) || this.x < (this.size/2)){
          this.xDir = this.xDir * -1;
          
      }

      if(this.y > (height-(this.size/2)) || this.y < (this.size/2)){
          this.yDir = this.yDir * -1;
      }

  }

  display() {
      stroke(10);
      rectMode(CENTER);
      fill(0);
      rect(this.x, this.y,this.size,this.size)
  }

}

class MovingCircle extends MovingShape {
    
  constructor(startX, startY, startSize, colour){
    super(startX,startY,startSize);
    this.colour = colour;
}

move() {
  super.move();

}

display() {
  noStroke();
  fill(255,182,193);
  ellipse(this.x, this.y,this.size,this.size);
}

}

